/****** Object:  View [dbo].[V_EST_PED_CP_VINCULOS]    Script Date: 04/11/2013 10:05:53 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PED_CP_VINCULOS]'))
DROP VIEW [dbo].[V_EST_PED_CP_VINCULOS]
GO
--SELECT * FROM V_EST_PED_CP_VINCULOS WHERE CD_EMP = 1 AND CD_FILIAL = 998 AND CD_PED = 1500 ORDER BY ORDEM
CREATE VIEW V_EST_PED_CP_VINCULOS AS
SELECT
	EST_NF_ENT.NR_NF, 
	EST_NF_ENT.DT_ENT, 
	EST_NF_ENT.CD_USU, 
	GLB_USU.NM_USU,
	EST_NF_ENT_PED_CP.CD_EMP,
	EST_NF_ENT_PED_CP.CD_FILIAL,
	EST_NF_ENT_PED_CP.CD_PED,
	'VINCULO NOTA FISCAL' AS DS_TIPO,
	99 AS ORDEM
FROM
	EST_NF_ENT_PED_CP INNER JOIN EST_NF_ENT ON
	EST_NF_ENT_PED_CP.CD_EMP = EST_NF_ENT.CD_EMP AND
	EST_NF_ENT_PED_CP.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT_PED_CP.CD_NF = EST_NF_ENT.CD_NF 
	INNER JOIN GLB_USU ON
	EST_NF_ENT.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT
	TOP 1 0 AS NR_NF, 
	EST_PED_CP_IT_CANCEL_SLD.DT_CANCEL, 
	EST_PED_CP_IT_CANCEL_SLD.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP_IT_CANCEL_SLD.CD_EMP,
	EST_PED_CP_IT_CANCEL_SLD.CD_FILIAL,
	EST_PED_CP_IT_CANCEL_SLD.CD_PED,
	'CANCELAMENTO SALDO' AS DS_TIPO,
	4 AS ORDEM
FROM
	EST_PED_CP_IT_CANCEL_SLD INNER JOIN EST_NF_ENT ON
	EST_PED_CP_IT_CANCEL_SLD.CD_EMP = EST_NF_ENT.CD_EMP AND
	EST_PED_CP_IT_CANCEL_SLD.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
	EST_PED_CP_IT_CANCEL_SLD.CD_PED = EST_NF_ENT.CD_PED 
	INNER JOIN GLB_USU ON
	EST_PED_CP_IT_CANCEL_SLD.CD_USU = GLB_USU.CD_USU 	
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO.NR_NF, 
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.DT_CAD, 
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_USU, 
	GLB_USU.NM_USU,
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_EMP,
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_FILIAL,
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_PED,
	'DANFE PENDENTE VINCULADO' AS DS_TIPO,
	0 AS ORDEM
FROM
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP INNER JOIN EST_NF_ENT_DANFE_PROVISORIO ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_CTR  = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_PENDENTE ON 
	EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_PENDENTE.CD_CTR
	INNER JOIN GLB_USU ON
	EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP.CD_USU = GLB_USU.CD_USU 
UNION ALL
SELECT
	EST_PED_CP.CD_PED AS NR_NF, 
	EST_PED_CP.DT_EMI, 
	EST_PED_CP.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP.CD_EMP,
	EST_PED_CP.CD_FILIAL,
	EST_PED_CP.CD_PED,
	'PEDIDO DE COMPRAS VINCULADO A ENTREGA PBM' AS DS_TIPO,
	0 AS ORDEM
FROM
	EST_PED_CP INNER JOIN EST_PED_CP_PBM ON
	EST_PED_CP.CD_EMP  = EST_PED_CP_PBM.CD_EMP AND
	EST_PED_CP.CD_FILIAL  = EST_PED_CP_PBM.CD_FILIAL AND
	EST_PED_CP.CD_PED  = EST_PED_CP_PBM.CD_PED 
	INNER JOIN GLB_USU ON
	EST_PED_CP.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT
	EST_PED_CP.CD_PED AS NR_NF, 
	EST_PED_CP_VINCULADA.DT_CAD, 
	EST_PED_CP.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP.CD_EMP,
	EST_PED_CP.CD_FILIAL,
	EST_PED_CP.CD_PED,
	'PENDENCIA VINCULADA A FILIAL ' + CONVERT(VARCHAR(10),EST_PED_CP_VINCULADA.CD_FILIAL_VINCULADA) AS DS_TIPO,
	0 AS ORDEM
FROM
	EST_PED_CP INNER JOIN EST_PED_CP_VINCULADA ON
	EST_PED_CP.CD_EMP  = EST_PED_CP_VINCULADA.CD_EMP AND
	EST_PED_CP.CD_FILIAL  = EST_PED_CP_VINCULADA.CD_FILIAL AND
	EST_PED_CP.CD_PED  = EST_PED_CP_VINCULADA.CD_PED 
	INNER JOIN GLB_USU ON
	EST_PED_CP_VINCULADA.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT
	EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL AS NR_NF, 
	EST_PED_CP.DT_EMI, 
	EST_PED_CP.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP.CD_EMP,
	EST_PED_CP.CD_FILIAL,
	EST_PED_CP.CD_PED,
	'DEMANDA DE ORIGEM' AS DS_TIPO,
	0 AS ORDEM
FROM
	EST_PED_CP INNER JOIN EST_PED_ELTR_FORN_PED_CP ON
	EST_PED_CP.CD_EMP  = EST_PED_ELTR_FORN_PED_CP.CD_EMP AND
	EST_PED_CP.CD_FILIAL  = EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR AND
	EST_PED_CP.CD_PED  = EST_PED_ELTR_FORN_PED_CP.CD_PED 
	INNER JOIN GLB_USU ON
	EST_PED_CP.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT
	EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA AS NR_NF, 
	EST_NF_ENT_PRE_ENTRADA.DT_CAD, 
	EST_NF_ENT_PRE_ENTRADA.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP.CD_EMP,
	EST_PED_CP.CD_FILIAL,
	EST_PED_CP.CD_PED,
	'VINCULADO A PRE-ENTRADA ' AS DS_TIPO,
	2 AS ORDEM
FROM
	EST_PED_CP INNER JOIN EST_NF_ENT_PRE_ENTRADA ON
	EST_PED_CP.CD_EMP  = EST_NF_ENT_PRE_ENTRADA.CD_EMP AND
	EST_PED_CP.CD_FILIAL  = EST_NF_ENT_PRE_ENTRADA.CD_FILIAL AND
	EST_PED_CP.CD_PED  = EST_NF_ENT_PRE_ENTRADA.CD_PED 
	INNER JOIN GLB_USU ON
	EST_NF_ENT_PRE_ENTRADA.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT
	EST_NF_ENT_DANFE_PROVISORIO.NR_NF, 
	EST_NF_ENT_DANFE_PROVISORIO.DT_EMIS_NF, 
	EST_PED_CP.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP.CD_EMP,
	EST_PED_CP.CD_FILIAL,
	EST_PED_CP.CD_PED,
	'PEDIDO DE COMPRAS GERADO ATRAVES DE DANFE PENDENTE DE ENTRADA' DS_TIPO,
	1 AS ORDEM
FROM
	EST_PED_CP INNER JOIN EST_NF_ENT_DANFE_PROVISORIO ON
	EST_PED_CP.CD_CTR_DANFE  = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR 
	INNER JOIN GLB_USU ON
	EST_PED_CP.CD_USU = GLB_USU.CD_USU
UNION ALL
SELECT  
	EST_WMS_ENT.CD_PED_WMS AS NR_NF, 
	EST_NF_ENT_PRE_ENTRADA.DT_CAD, 
	EST_NF_ENT_PRE_ENTRADA.CD_USU, 
	GLB_USU.NM_USU,
	EST_PED_CP.CD_EMP,
	EST_PED_CP.CD_FILIAL,
	EST_PED_CP.CD_PED,
	CASE WHEN EST_WMS_ENT_PEND.CD_PED_WMS IS NULL THEN
		CASE WHEN NOT EST_WMS_ENT_RET.CD_PED_WMS IS NULL THEN
			CASE WHEN EST_WMS_ENT_RET_PEND.CD_PED_WMS IS NULL THEN
				'FINALIZADO PELO WMS PRE-ENTRADA ' + CONVERT(VARCHAR(50),EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA)
			ELSE
				'PENDENTE DE ENVIO RETORNO DO WMS PRE-ENTRADA ' + CONVERT(VARCHAR(50),EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA)
			END
		ELSE
			'SEM RETORNO WMS PRE-ENTRADA ' + CONVERT(VARCHAR(50),EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA)
		END
	ELSE
		'PENDENTE DE ENVIO AO WMS PRE-ENTRADA ' + CONVERT(VARCHAR(50),EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA)
	END AS DS_TIPO,
	3 AS ORDEM
FROM  
	EST_NF_ENT_PRE_ENTRADA INNER JOIN EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT ON 
	EST_NF_ENT_PRE_ENTRADA.CD_EMP = EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_EMP AND 
	EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA = EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_CTR_PRE_ENTRADA 
	INNER JOIN EST_PED_CP ON
	EST_NF_ENT_PRE_ENTRADA.CD_EMP  = EST_PED_CP.CD_EMP AND
	EST_NF_ENT_PRE_ENTRADA.CD_FILIAL  = EST_PED_CP.CD_FILIAL AND
	EST_NF_ENT_PRE_ENTRADA.CD_PED  = EST_PED_CP.CD_PED 
	INNER JOIN EST_WMS_ENT ON 
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT.CD_PED_WMS
	INNER JOIN GLB_USU ON
	EST_WMS_ENT.CD_USU  = GLB_USU.CD_USU 
	LEFT JOIN EST_WMS_ENT_PEND ON 
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT_PEND.CD_PED_WMS
	LEFT JOIN 
		(SELECT
			DISTINCT CD_PED_WMS
		FROM
			EST_WMS_ENT_RET) EST_WMS_ENT_RET ON		
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT_RET.CD_PED_WMS
	LEFT JOIN 
		(SELECT
			DISTINCT CD_PED_WMS
		FROM
			EST_WMS_ENT_RET_PEND) EST_WMS_ENT_RET_PEND ON		
	EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT.CD_PED_WMS = EST_WMS_ENT_RET_PEND.CD_PED_WMS